define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/page/content/_primary-header.html',
    'modules/page/core/behaviors/focus-on-header-behavior',
],
function (_, Backbone, Marionette, _primaryHeaderTemplate, Focus) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'primary-content',
        // no default template
        events: {'click #back-btn': 'routeToPrevious'},
        behaviors: {Focus: {behaviorClass: Focus}},
        initialize: function(options) {
            if (options.previousRoute) {
                this.previousRoute = options.previousRoute;
            }
        },
        routeToPrevious: function() {
            Backbone.history.navigate(this.previousRoute, {trigger: true});
        },
        templateContext: {primaryHeader: _.template(_primaryHeaderTemplate)},
    });
});
